/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.AtomicDouble;
import io.github.fabricators_of_create.porting_lib.tool.ItemAbilities;
import io.github.fabricators_of_create.porting_lib.tool.ItemAbility;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_4481;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockToolSwapUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEntityToolSwapUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.SophisticatedShearable;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.SwordRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ToolRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapMode;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class ToolSwapperUpgradeWrapper
extends UpgradeWrapperBase<ToolSwapperUpgradeWrapper, ToolSwapperUpgradeItem>
implements IBlockClickResponseUpgrade,
IAttackEntityResponseUpgrade,
IBlockToolSwapUpgrade,
IEntityToolSwapUpgrade {
    private static final LoadingCache<class_1799, Boolean> isToolCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<class_1799, Boolean>(){

        public Boolean load(class_1799 key) {
            return ToolSwapperUpgradeWrapper.canPerformToolAction(key);
        }
    });
    private final FilterLogic filterLogic;
    @Nullable
    private class_2960 toolCacheFor = null;
    private final Queue<class_1799> toolCache = new LinkedList<class_1799>();
    private class_2248 lastMinedBlock = class_2246.field_10124;
    private static final Set<ItemAbility> BLOCK_MODIFICATION_ACTIONS = Set.of(ItemAbilities.AXE_STRIP, ItemAbilities.AXE_SCRAPE, ItemAbilities.AXE_WAX_OFF, ItemAbilities.SHOVEL_FLATTEN, ItemAbilities.SHEARS_CARVE, ItemAbilities.SHEARS_HARVEST);

    protected ToolSwapperUpgradeWrapper(IStorageWrapper backpackWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((Integer)Config.SERVER.toolSwapperUpgrade.filterSlots.get()).intValue(), ModCoreDataComponents.FILTER_ATTRIBUTES);
    }

    @Override
    public boolean onBlockClick(class_1657 player, class_2338 pos) {
        ToolSwapMode toolSwapMode = this.getToolSwapMode();
        if (player.method_7337() || player.method_7325() || toolSwapMode == ToolSwapMode.NO_SWAP) {
            return false;
        }
        class_1799 mainHandItem = player.method_6047();
        if (mainHandItem.method_7909() instanceof BackpackItem || toolSwapMode == ToolSwapMode.ONLY_TOOLS && this.isSword(mainHandItem, player) || !this.isSword(mainHandItem, player) && this.isNotTool(mainHandItem) || !this.filterLogic.matchesFilter(mainHandItem)) {
            return false;
        }
        class_2680 state = player.method_37908().method_8320(pos);
        class_2248 block = state.method_26204();
        double mainToolSpeed = 0.0;
        if (this.isGoodAtBreakingBlock(state, mainHandItem)) {
            if (this.lastMinedBlock == block) {
                return true;
            }
            mainToolSpeed = mainHandItem.method_7924(state);
        }
        this.lastMinedBlock = block;
        return this.tryToSwapTool(player, state, mainToolSpeed, mainHandItem);
    }

    private boolean tryToSwapTool(class_1657 player, class_2680 state, double mainHandItemSpeed, class_1799 mainHandItem) {
        AtomicReference<class_1799> selectedTool = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicInteger selectedSlot = new AtomicInteger(-1);
        AtomicDouble bestSpeed = new AtomicDouble(mainHandItemSpeed);
        InventoryHandler backpackInventory = this.storageWrapper.getInventoryHandler();
        InventoryHelper.iterate((SlottedStorage)backpackInventory, (slot, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            if (this.isAllowedAndGoodAtBreakingBlock(state, (class_1799)stack)) {
                float destroySpeed = stack.method_7924(state);
                if (bestSpeed.get() < (double)destroySpeed) {
                    bestSpeed.set((double)destroySpeed);
                    selectedSlot.set((int)slot);
                    selectedTool.set((class_1799)stack);
                }
            }
        });
        class_1799 tool = selectedTool.get();
        if (!tool.method_7960() && this.hasSpaceInBackpackOrCanPlaceInTheSlotOfSwappedTool((IItemHandlerSimpleInserter)backpackInventory, mainHandItem, tool, selectedSlot.get())) {
            player.method_6122(class_1268.field_5808, backpackInventory.extractItem(selectedSlot.get(), 1, false));
            backpackInventory.insertItem(mainHandItem, false);
            return true;
        }
        return false;
    }

    private boolean hasSpaceInBackpackOrCanPlaceInTheSlotOfSwappedTool(IItemHandlerSimpleInserter backpackInventory, class_1799 mainHandItem, class_1799 tool, int selectedSlot) {
        return backpackInventory.insertItem(mainHandItem, true).method_7960() || tool.method_7947() == 1 && backpackInventory.isItemValid(selectedSlot, mainHandItem);
    }

    private boolean isAllowedAndGoodAtBreakingBlock(class_2680 state, class_1799 stack) {
        return this.filterLogic.matchesFilter(stack) && this.isGoodAtBreakingBlock(state, stack);
    }

    private boolean isGoodAtBreakingBlock(class_2680 state, class_1799 stack) {
        return stack.method_7951(state) && (double)stack.method_7924(state) > 1.5;
    }

    @Override
    public boolean onAttackEntity(class_1657 player) {
        if (!this.shouldSwapWeapon()) {
            return false;
        }
        class_1799 mainHandItem = player.method_6047();
        if (this.isSword(mainHandItem, player)) {
            return true;
        }
        if (mainHandItem.method_7909() instanceof BackpackItem || this.isNotTool(mainHandItem) || !this.filterLogic.matchesFilter(mainHandItem)) {
            return false;
        }
        return this.tryToSwapInWeapon(player, mainHandItem);
    }

    private boolean isNotTool(class_1799 stack) {
        return (Boolean)isToolCache.getUnchecked((Object)stack) == false;
    }

    private static boolean canPerformToolAction(class_1799 stack) {
        return ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ItemAbilities.DEFAULT_AXE_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ItemAbilities.DEFAULT_HOE_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ItemAbilities.DEFAULT_PICKAXE_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ItemAbilities.DEFAULT_SHOVEL_ACTIONS) || ToolSwapperUpgradeWrapper.canPerformAnyAction(stack, ItemAbilities.DEFAULT_SHEARS_ACTIONS);
    }

    private static boolean canPerformAnyAction(class_1799 stack, Set<ItemAbility> toolActions) {
        for (ItemAbility toolAction : toolActions) {
            if (!stack.canPerformAction(toolAction)) continue;
            return true;
        }
        return false;
    }

    private boolean isSword(class_1799 stack, class_1657 player) {
        if (SwordRegistry.isSword(stack)) {
            return true;
        }
        class_1324 attackDamage = player.method_5996(class_5134.field_23721);
        if (!stack.method_7960() && stack.canPerformAction(ItemAbilities.SWORD_SWEEP)) {
            return attackDamage != null && attackDamage.method_6199(class_1792.field_8006) != null;
        }
        return false;
    }

    private boolean tryToSwapInWeapon(class_1657 player, class_1799 mainHandItem) {
        AtomicReference<class_1799> bestAxe = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicDouble bestAxeDamage = new AtomicDouble(0.0);
        AtomicReference<class_1799> bestSword = new AtomicReference<class_1799>(class_1799.field_8037);
        AtomicDouble bestSwordDamage = new AtomicDouble(0.0);
        this.updateBestWeapons(bestAxe, bestAxeDamage, bestSword, bestSwordDamage, mainHandItem);
        ITrackedContentsItemHandler backpackInventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        InventoryHelper.iterate((SlottedStorage)backpackInventory, (slot, stack) -> {
            if (this.filterLogic.matchesFilter(stack)) {
                this.updateBestWeapons(bestAxe, bestAxeDamage, bestSword, bestSwordDamage, (class_1799)stack);
            }
        });
        if (!bestSword.get().method_7960()) {
            return this.swapWeapon(player, mainHandItem, (IItemHandlerSimpleInserter)backpackInventory, bestSword.get());
        }
        if (!bestAxe.get().method_7960()) {
            return this.swapWeapon(player, mainHandItem, (IItemHandlerSimpleInserter)backpackInventory, bestAxe.get());
        }
        return false;
    }

    private void updateBestWeapons(AtomicReference<class_1799> bestAxe, AtomicDouble bestAxeDamage, AtomicReference<class_1799> bestSword, AtomicDouble bestSwordDamage, class_1799 stack) {
        class_1324 attribute = new class_1324(class_5134.field_23721, a -> {});
        stack.method_57354(class_1304.field_6173, (att, m) -> {
            if (!att.equals((Object)class_5134.field_23721)) {
                return;
            }
            attribute.method_6202(m);
            attribute.method_26835(m);
        });
        double damageValue = attribute.method_6194();
        if (stack.canPerformAction(ItemAbilities.AXE_DIG)) {
            if (damageValue > bestAxeDamage.get()) {
                bestAxe.set(stack);
                bestAxeDamage.set(damageValue);
            }
        } else if ((SwordRegistry.isSword(stack) || stack.canPerformAction(ItemAbilities.SWORD_SWEEP)) && damageValue > bestSwordDamage.get()) {
            bestSword.set(stack);
            bestSwordDamage.set(damageValue);
        }
    }

    private boolean swapWeapon(class_1657 player, class_1799 mainHandItem, IItemHandlerSimpleInserter backpackInventory, class_1799 sword) {
        if (sword == mainHandItem) {
            return true;
        }
        class_1799 swordCopy = sword.method_7972();
        swordCopy.method_7939(1);
        InventoryHelper.extractFromInventory((class_1799)swordCopy, (IItemHandlerSimpleInserter)backpackInventory, (boolean)false);
        if (backpackInventory.insertItem(mainHandItem, true).method_7960()) {
            player.method_6122(class_1268.field_5808, swordCopy);
            backpackInventory.insertItem(mainHandItem, false);
            return true;
        }
        backpackInventory.insertItem(swordCopy, false);
        return false;
    }

    public boolean hideSettingsTab() {
        return !((ToolSwapperUpgradeItem)this.upgradeItem).hasSettingsTab();
    }

    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public boolean shouldSwapWeapon() {
        return (Boolean)this.upgrade.sophisticatedCore_getOrDefault(ModDataComponents.SHOULD_SWAP_WEAPON, (Object)true);
    }

    public void setSwapWeapon(boolean shouldSwapWeapon) {
        this.upgrade.sophisticatedCore_set(ModDataComponents.SHOULD_SWAP_WEAPON, (Object)shouldSwapWeapon);
        this.save();
    }

    public ToolSwapMode getToolSwapMode() {
        return (ToolSwapMode)((Object)this.upgrade.sophisticatedCore_getOrDefault(ModDataComponents.TOOL_SWAP_MODE, (Object)ToolSwapMode.ANY));
    }

    public void setToolSwapMode(ToolSwapMode toolSwapMode) {
        this.upgrade.sophisticatedCore_set(ModDataComponents.TOOL_SWAP_MODE, (Object)toolSwapMode);
        this.save();
    }

    @Override
    public boolean onEntityInteract(class_1937 level, class_1297 entity, class_1657 player) {
        if (!((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress()) {
            return false;
        }
        return this.tryToSwapTool(player, stack -> this.itemWorksOnEntity((class_1799)stack, entity), class_7923.field_41177.method_10221((Object)entity.method_5864()));
    }

    private boolean itemWorksOnEntity(class_1799 stack, class_1297 entity) {
        if (this.isShearableEntity(entity, stack) && this.isShearsItem(stack)) {
            return true;
        }
        return ToolRegistry.isToolForEntity(stack, entity);
    }

    @Override
    public boolean onBlockInteract(class_1937 level, class_2338 pos, class_2680 blockState, class_1657 player) {
        if (!((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress()) {
            return false;
        }
        return this.tryToSwapTool(player, stack -> this.itemWorksOnBlock(level, pos, blockState, player, (class_1799)stack), class_7923.field_41175.method_10221((Object)blockState.method_26204()));
    }

    private boolean tryToSwapTool(class_1657 player, Predicate<class_1799> isToolValid, @Nullable class_2960 targetRegistryName) {
        class_1799 tool;
        class_1799 mainHandStack = player.method_6047();
        if (mainHandStack.method_7909() instanceof BackpackItem) {
            return false;
        }
        if (this.toolCacheFor == null || !this.toolCacheFor.equals((Object)targetRegistryName)) {
            this.toolCache.clear();
            this.toolCacheFor = targetRegistryName;
        }
        boolean itemInHandIsValid = isToolValid.test(mainHandStack);
        ITrackedContentsItemHandler backpackInventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        if (itemInHandIsValid && this.toolCache.stream().noneMatch(st -> class_1799.method_7984((class_1799)st, (class_1799)mainHandStack))) {
            this.toolCache.offer(mainHandStack);
        }
        if ((tool = this.findToolToSwap((IItemHandlerSimpleInserter)backpackInventory, isToolValid)).method_7960()) {
            return false;
        }
        if ((tool = tool.method_7972().method_7971(1)).method_7947() == 1 || backpackInventory.insertItem(mainHandStack, true).method_7960()) {
            player.method_6122(class_1268.field_5808, InventoryHelper.extractFromInventory((class_1799)tool, (IItemHandlerSimpleInserter)backpackInventory, (boolean)false));
            backpackInventory.insertItem(mainHandStack, false);
            this.toolCache.offer(tool);
        }
        return true;
    }

    private class_1799 findToolToSwap(IItemHandlerSimpleInserter backpackInventory, Predicate<class_1799> isValidTool) {
        HashSet<class_1799> alreadyGivenBefore = new HashSet<class_1799>();
        AtomicReference<class_1799> toolFound = new AtomicReference<class_1799>(class_1799.field_8037);
        InventoryHelper.iterate((SlottedStorage)backpackInventory, (slot, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            if (!this.hasEquivalentItem((Collection<class_1799>)this.toolCache, (class_1799)stack)) {
                if (isValidTool.test((class_1799)stack)) {
                    toolFound.set((class_1799)stack);
                }
            } else {
                alreadyGivenBefore.add((class_1799)stack);
            }
        }, () -> !((class_1799)toolFound.get()).method_7960());
        if (toolFound.get().method_7960() && !alreadyGivenBefore.isEmpty()) {
            while (this.toolCache.peek() != null) {
                class_1799 itemStack = this.toolCache.poll();
                if (!this.hasEquivalentItem(alreadyGivenBefore, itemStack)) continue;
                toolFound.set(itemStack);
                break;
            }
        }
        return toolFound.get();
    }

    private boolean hasEquivalentItem(Collection<class_1799> alreadyGivenBefore, class_1799 stack) {
        for (class_1799 givenTool : alreadyGivenBefore) {
            if (!class_1799.method_7984((class_1799)givenTool, (class_1799)stack)) continue;
            return true;
        }
        return false;
    }

    private boolean itemWorksOnBlock(class_1937 level, class_2338 pos, class_2680 blockState, class_1657 player, class_1799 stack) {
        for (ItemAbility action : BLOCK_MODIFICATION_ACTIONS) {
            if (!stack.canPerformAction(action) || blockState.getToolModifiedState(new class_1838(level, player, class_1268.field_5808, stack, new class_3965(class_243.method_24953((class_2382)pos), class_2350.field_11036, pos, true)), action, true) == null) continue;
            return true;
        }
        class_2248 block = blockState.method_26204();
        if (this.isShearInteractionBlock(level, pos, stack, block) && this.isShearsItem(stack)) {
            return true;
        }
        return ToolRegistry.isToolForBlock(stack, block, level, blockState, pos);
    }

    private boolean isShearsItem(class_1799 stack) {
        return stack.method_7909() instanceof class_1820 || stack.method_31573(ConventionalItemTags.SHEAR_TOOLS);
    }

    private boolean isShearInteractionBlock(class_1937 level, class_2338 pos, class_1799 stack, class_2248 block) {
        SophisticatedShearable shearable;
        return block instanceof SophisticatedShearable && (shearable = (SophisticatedShearable)block).sophisticatedBackpacks_isShearable(null, stack, level, pos) || block instanceof class_4481;
    }

    private boolean isShearableEntity(class_1297 entity, class_1799 stack) {
        SophisticatedShearable shearable;
        return entity instanceof SophisticatedShearable && (shearable = (SophisticatedShearable)entity).sophisticatedBackpacks_isShearable(null, stack, entity.method_37908(), entity.method_24515());
    }

    @Override
    public boolean canProcessBlockInteract() {
        return ((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress();
    }

    @Override
    public boolean canProcessEntityInteract() {
        return ((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress();
    }
}

